<style>
    body {
        font-family: 'Ubuntu', sans-serif;
        font-weight: 600;
    }
    .triangle {
        position: absolute;
        bottom: 0;
        left: 50%;
        transform: translateX(-50%);
        width: 0;
        height: 0;
        border-left: 90px solid transparent;
        border-right: 90px solid transparent;
        border-top: 60px solid rgba(255, 255, 255, 0.5);
        z-index: 1;
    }
</style>

**Midnight Prism Theme & Icons**

**Midnight Prism** is a sleek, modern dark theme designed to create a visually appealing coding environment. With its carefully balanced color palette and elegant icons, this theme draws inspiration from the calmness of the night sky and the flow of creativity, featuring Glyph icons that are inspired by the Symbols icon theme, offering a smooth and vibrant experience for all coders.

<div align="center" style="display: grid; grid-template-columns: repeat(2, 1fr); gap: 10px; padding: 20px; position: relative; background: url('data:image/svg+xml,%3Csvg xmlns%3D%22http://www.w3.org/2000/svg%22 viewBox%3D%220 0 800 400%22%3E%3Cpath fill%3D%22%2300c6ff%22 fill-opacity%3D%220.6%22 d%3D%22M0 50L200 150L400 90L600 250L800 100V400H0z%22/%3E%3Cpath fill%3D%22%230072ff%22 fill-opacity%3D%220.4%22 d%3D%22M0 150L200 250L400 190L600 350L800 200V400H0z%22/%3E%3C/svg%3E'); background-size: cover; border-radius: 15px;">
  <div class="triangle"></div>
  <img alt="black" src="https://i.imgur.com/p0GC23G.png" />
  <img alt="blue" src="https://imgur.com/jt702IH.png" />
  <img alt="sky" src="https://i.imgur.com/4QrNZ1N.png" />
  <img alt="green" src="https://imgur.com/z24Uh7p.png" />
  <img alt="orange" src="https://imgur.com/hajDWIr.png" />
  <img alt="grey" src="https://imgur.com/gNBcD7i.png" />
  <img alt="cristal" src="https://imgur.com/ZqCLYSB.png" />
  <img alt="diamond" src="https://i.imgur.com/NH3MPVv.png" />
  <img alt="emerald" src="https://i.imgur.com/U8vPDdD.png" />
  <img alt="ame" src="https://i.imgur.com/VWAMrIA.png" />
  <img alt="ruby" src="https://i.imgur.com/bpVtg1d.png" />
  <img alt="gold" src="https://imgur.com/LqvEnU5.png" />
  <img alt="github" src="https://imgur.com/0pHHeWv.png" />
  <img alt="idx" src="https://imgur.com/45rajcx.png" />
  <img alt="light diamond" src="https://imgur.com/q8JLIhC.png" />
  <img alt="light emerald" src="https://imgur.com/og0UbUd.png" />
  <img alt="light" src="https://imgur.com/1lmFFu5.png" />
</div>

## ⭐ Key Features

- **Dark Grey Base**: Establishes a clean, minimalist workspace that allows vibrant colors to stand out.
- **Vibrant Accents**: Incorporates shades of **dark blue**, **red/orange**, and **green** for effective syntax highlighting and key UI elements.
- **Elegant Icons**: Uniquely designed icons enhance the aesthetic appeal and functionality of the UI, providing a cohesive and enjoyable coding experience.
- **Dark and Light Variants**: Offers both dark and light themes, providing flexibility for different lighting conditions and personal preferences, ensuring comfort during coding sessions.
- **Smooth Color Transitions**: Inspired by the natural shifts of twilight, the colors blend seamlessly across the UI for a cohesive look.
- **Dynamic Color Variants**: Includes touches of **twilight purple** and **midnight teal** in various UI elements, enhancing the overall experience.
- **Eye-Strain Reduction**: Optimized for long coding sessions with balanced contrast and smooth color blending, reducing eye strain.

## 🚀 Installation

1. Open the Extensions sidebar in VS Code.
2. Search for **Midnight Prism**.
3. Click **Install**.
4. Open the Theme Palette with `Ctrl+K Ctrl+T` (or `⇧ K ⇧ T`).
5. Select **Color Theme** and choose **Midnight Prism**.

## Acknowledgment

The Glyph Icons Inspired by the [Symbols icon theme](https://marketplace.visualstudio.com/items?itemName=miguelsolorio.symbols) on the VS Code Marketplace.

## ☕ Sponsor / Donate

If you enjoy using this theme and would like to support its development, consider donating or sponsoring. Your support helps keep the project alive and growing!

[![Sponsor](https://img.shields.io/badge/Sponsor-%E2%9D%A4-red?style=for-the-badge)](https://github.com/sponsors/Raoufbaa)

[![Buy Me a Coffee](https://img.shields.io/badge/Buy%20Me%20a%20Coffee-%F0%9F%98%95-orange?style=for-the-badge)](https://www.buymeacoffee.com/raoufbaa)

## 📄 License

This theme is released under the MIT License.

If you find anything missing, please [create an issue](https://github.com/Raoufbaa/raouf-dark-Grey-theme/issues) so I can make the theme as compatible as possible! ❤️

---

**Published by**  
[Raouf](https://github.com/Raoufbaa)

**Check out the GitHub repository** for this theme: [raouf-dark-Grey-theme](https://github.com/Raoufbaa/raouf-dark-Grey-theme)

**Visit my portfolio**: [raoufbakhti.is-a.dev](https://raoufbakhti.is-a.dev/)

### Give a ⭐ if you like it!

---
